﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.Odbc;
using System.Data;
using System.Windows.Forms;
using System.Data.OleDb;
using System.Data.SqlClient;
using System.IO;
using System.Xml.Serialization;
//using ServiceStack.ServiceClient.Web;
using System.Reflection;
//using ServiceStack.OrmLite;
//using ServiceStack.OrmLite;

namespace PsgServer
{
    public class SqlConnection
    {
        #region Fields / Constructors

        Server server;

        public string sqlcommand = string.Empty;
        //public OrmLiteConnectionFactory factory = new OrmLiteConnectionFactory("Server=127.0.0.1;Port=5432;Database=elt;User Id=postgres;Password=postgres;", PostgreSqlDialect.Provider);
        public string connectionString = "Driver={PostgreSQL ODBC Driver(UNICODE)};Server=localhost;Database=elt;Port=5432;Uid=postgres;Pwd=postgres;SSL=No;";

        public OdbcConnection conn = new OdbcConnection();
        public OdbcCommand cmd = new OdbcCommand();
        public OdbcDataAdapter adapter = new OdbcDataAdapter();
        public DataTable dt = new DataTable();

        public SqlConnection(Server _server)
        {
            server = _server;
        }

        #endregion

        public void Open()
        {
            conn.ConnectionString = connectionString;
            conn.Open();
        }
        public void OpenSqlite()
        {
            if (File.Exists(Server.WorkDirectory+"psgdata.db"))
                conn.ConnectionString = @"DRIVER=SQLite ODBC (UTF-8) Driver;Database="+Server.WorkDirectory+"psgdata.db;LongNames=0;Timeout=1000;NoTXN=0;SyncPragma=NORMAL;StepAPI=0;";
            else
                conn.ConnectionString = @"DRIVER=SQLite ODBC (UTF-8) Driver;Database=" + Server.CurrentDirectory + @"\..\psgdata.db;LongNames=0;Timeout=1000;NoTXN=0;SyncPragma=NORMAL;StepAPI=0;";
            conn.Open();
        }

        public void Open(string _connectstring)
        {
            conn.ConnectionString = _connectstring;
            conn.Open();
        }

        public void Close()
        {
            conn.Close();
        }

        public void CloseSqlite()
        {
            conn.Close();
        }

        public void filters(string filters)
        {
            if (!string.IsNullOrEmpty(filters))
                this.sqlcommand = this.sqlcommand + filters.ToString().Replace("*", "'");
        }

        public void filters(object[] param, int i)
        {
            if (param.Length <= i)
                return;

            string filters = param[i].ToString();
            string tmp = filters.Replace("'", "");

            if (!string.IsNullOrEmpty(tmp))
            {
                this.sqlcommand = this.sqlcommand + tmp.ToString().Replace("*", "'");
                return;
            }
            else
                return;
        }

        public void sqlexec(string _connString)
        {
            if (string.IsNullOrEmpty(server.cname))
            {
                server.smsg("Cursor name is required.");
                return;
            }

            if (string.IsNullOrEmpty(sqlcommand))
            {
                server.smsg("Command is required.");
                return;
            }

            try
            {
                cmd.CommandText = sqlcommand;
                adapter.SelectCommand = cmd;
                adapter.SelectCommand.Connection = conn;

                dt.TableName = server.cname;
                Open(_connString);
                adapter.Fill(dt);

                XmlSerializer ser = new XmlSerializer(typeof(DataTable));
                TextWriter writer = new StreamWriter(server.cname + Server.PsgGuid + ".xml");
                ser.Serialize(writer, dt);
                writer.Close();

                dt.WriteXmlSchema(server.cname + Server.PsgGuid + ".xsd");
                dt.Clear();
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                conn.Close();
            }
        }

        public void sqlexec(string _connString, string outFileName)
        {
            if (string.IsNullOrEmpty(server.cname))
            {
                server.smsg("Cursor name is required.");
                return;
            }

            if (string.IsNullOrEmpty(sqlcommand))
            {
                server.smsg("Command is required.");
                return;
            }

            try
            {                
                cmd.CommandText = sqlcommand;
                adapter.SelectCommand = cmd;
                adapter.SelectCommand.Connection = conn;

                dt.TableName = server.cname;
                Open(_connString);
                adapter.Fill(dt);

                XmlSerializer ser = new XmlSerializer(typeof(DataTable));
                TextWriter writer = new StreamWriter(outFileName + ".xml");
                ser.Serialize(writer, dt);
                writer.Close();

                dt.WriteXmlSchema(outFileName + ".xsd");
                dt.Clear();
            }
            catch (Exception ex)
            {
                server.smsg(ex.Message);
            }
            finally
            {
                conn.Close();
            }
        }
    }
}

